package com.ejie.ab04b.service;
import com.ejie.ab04b.dao.TecnicoOsalanDao;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.TecnicoOsalan;

/**
 * P5304s00ServiceImpl generated by UDA, 14-jun-2017 11:55:53.
 * @author UDA
 */

@Service(value = "tecnicoOsalanService")
public class TecnicoOsalanServiceImpl implements TecnicoOsalanService {

	@Autowired
	private TecnicoOsalanDao p5304s00Dao;

	/**
	 * Inserts a single row in the P5304s00 table.
	 * 
	 *  p5304s00 P5304s00
	 *  P5304s00
	 *
	 * @param p5304s00 the p 5304 s 00
	 * @return the tecnico osalan
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TecnicoOsalan add(TecnicoOsalan p5304s00) {
		return this.p5304s00Dao.add(p5304s00);
	}

	/**
	 * Updates a single row in the P5304s00 table.
	 * 
	 *  p5304s00 P5304s00
	 *  P5304s00
	 *
	 * @param p5304s00 the p 5304 s 00
	 * @return the tecnico osalan
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TecnicoOsalan update(TecnicoOsalan p5304s00) {
		return this.p5304s00Dao.update(p5304s00);
	 }

	/**
	 * Finds a single row in the P5304s00 table.
	 * 
	 *  p5304s00 P5304s00
	 *  P5304s00
	 *
	 * @param p5304s00 the p 5304 s 00
	 * @return the tecnico osalan
	 */
	public TecnicoOsalan find(TecnicoOsalan p5304s00) {
		return (TecnicoOsalan) this.p5304s00Dao.find(p5304s00);
	}
	
	/**
	 * Deletes a single row in the P5304s00 table.
	 * 
	 *  p5304s00 P5304s00
	 *
	 * @param p5304s00 the p 5304 s 00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TecnicoOsalan p5304s00) {
		this.p5304s00Dao.remove(p5304s00);
	}

	/**
	 * Finds a list of rows in the P5304s00 table.
	 * 
	 *  p5304s00 P5304s00
	 *  jqGridRequestDto JQGridRequestDto
	 *  List<P5304s00>
	 *
	 * @param p5304s00 the p 5304 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<TecnicoOsalan> findAll(TecnicoOsalan p5304s00, JQGridRequestDto jqGridRequestDto){
		return (List<TecnicoOsalan>) this.p5304s00Dao.findAll(p5304s00, jqGridRequestDto);
	}
    
	/**
	 * Finds rows in the P5304s00 table using like.
	 * 
	 *  p5304s00 P5304s00
	 *  jqGridRequestDto JQGridRequestDto
	 *  startsWith Boolean	 
	 *  List<P5304s00>
	 *
	 * @param p5304s00 the p 5304 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TecnicoOsalan> findAllLike(TecnicoOsalan p5304s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith){
		return (List<TecnicoOsalan>) this.p5304s00Dao.findAllLike(p5304s00, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */
	 
	/**
	 * Removes rows from the P5304s00 table.
	 * 
	 *  filterP5304s00 P5304s00
	 *  jqGridRequestDto JQGridRequestDto
	 *  startsWith Boolean
	 *
	 * @param filterP5304s00 the filter P 5304 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */	
	public void removeMultiple(TecnicoOsalan filterP5304s00, JQGridRequestDto jqGridRequestDto,  Boolean startsWith){
		this.p5304s00Dao.removeMultiple(filterP5304s00, jqGridRequestDto, startsWith);
	}
        
	/**
	 * Filter method in the P5304s00 table.
	 * 
	 *  filterP5304s00 P5304s00
	 *  jqGridRequestDto JQGridRequestDto
	 *  startsWith Boolean
	 *  JQGridResponseDto<P5304s00>
	 *
	 * @param filterP5304s00 the filter P 5304 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */	
	public JQGridResponseDto< TecnicoOsalan> filter(TecnicoOsalan filterP5304s00, JQGridRequestDto jqGridRequestDto,  Boolean startsWith){
		List<TecnicoOsalan> listaP5304s00 =  this.p5304s00Dao.findAllLike(filterP5304s00, jqGridRequestDto, false);
		Long recordNum =  this.p5304s00Dao.findAllLikeCount(filterP5304s00 != null ? filterP5304s00: new TecnicoOsalan (),false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds()!=null){
			List< TableRowDto< TecnicoOsalan>> reorderSelection = this.p5304s00Dao.reorderSelection(filterP5304s00, jqGridRequestDto, startsWith);
			return new JQGridResponseDto<TecnicoOsalan>(jqGridRequestDto, recordNum, listaP5304s00, reorderSelection);
		}
		return new JQGridResponseDto<TecnicoOsalan>(jqGridRequestDto, recordNum, listaP5304s00);   
	}
    
    /**
     * Searches rows in the P5304s00 table.
     * 
     *  filterP5304s00 P5304s00
     *  searchP5304s00 P5304s00
     *  jqGridRequestDto JQGridRequestDto
     *  startsWith Boolean
     *  List<TableRowDto<P5304s00>>
     *
     * @param filterP5304s00 the filter P 5304 s 00
     * @param searchP5304s00 the search P 5304 s 00
     * @param jqGridRequestDto the jq grid request dto
     * @param startsWith the starts with
     * @return the list
     */	
    public List< TableRowDto< TecnicoOsalan>> search(TecnicoOsalan filterP5304s00, TecnicoOsalan searchP5304s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith){
		return this.p5304s00Dao.search(filterP5304s00, searchP5304s00, jqGridRequestDto, startsWith);
	}
    
    /**
     * Reorder the selection made in P5304s00 table.
     * 
     *  filterP5304s00 P5304s00
     *  jqGridRequestDto JQGridRequestDto
     *  startsWith Boolean
     *  Object
     *
     * @param filterP5304s00 the filter P 5304 s 00
     * @param jqGridRequestDto the jq grid request dto
     * @param startsWith the starts with
     * @return the object
     */	
    public Object reorderSelection(TecnicoOsalan filterP5304s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith){
		return this.p5304s00Dao.reorderSelection(filterP5304s00, jqGridRequestDto, startsWith);
	}
    	
}

